//
//  RootViewController.h
//  ThinkGearTouch
//
//  Created by Horace Ko on 12/2/09.
//  Copyright NeuroSky, Inc. 2009. All rights reserved.
//

#import "TGAccessoryManager.h"
#import "TGAccessoryDelegate.h"

// the eSense values
typedef struct {
    int attention;
    int meditation;
} ESenseValues;

// the EEG power bands
typedef struct {
    int delta;
    int theta;
    int lowAlpha;
    int highAlpha;
    int lowBeta;
    int highBeta;
    int lowGamma;
    int highGamma;
} EEGValues;

@interface RootViewController : UITableViewController <TGAccessoryDelegate> {
    short rawValue;
    int blinkStrength;
    int poorSignalValue;
    
    ESenseValues eSenseValues;
    EEGValues eegValues;
    
    UIView * loadingScreen;
}

// TGAccessoryDelegate protocol methods
- (void)accessoryDidConnect:(EAAccessory *)accessory;
- (void)accessoryDidDisconnect;
- (void)dataReceived:(NSDictionary *)data;

@property (nonatomic, retain) IBOutlet UIView * loadingScreen;

@end